/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ObeliskInventory {
    public final List<ItemStack> items = new ArrayList<ItemStack>();
    public final List<ItemStack> armor = new ArrayList<ItemStack>();
    public final List<ItemStack> offhand = new ArrayList<ItemStack>();
    public int xp = 0;

    public boolean isEmpty() {
        return this.isItemsEmpty() && this.isArmorEmpty() && this.isOffhandEmpty();
    }

    public void dropAll(Level level, double x, double y, double z) {
        for (ItemStack stack : this.items) {
            Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
        for (ItemStack stack : this.armor) {
            Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
        for (ItemStack stack : this.offhand) {
            Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
        if (this.xp > 0) {
            level.m_7967_((Entity)new ExperienceOrb(level, x, y, z, this.xp));
        }
    }

    public boolean isItemsEmpty() {
        boolean bl = true;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isArmorEmpty() {
        boolean bl = true;
        for (ItemStack stack : this.armor) {
            if (stack.m_41619_()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isOffhandEmpty() {
        boolean bl = true;
        for (ItemStack stack : this.offhand) {
            if (stack.m_41619_()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isXpEmpty() {
        return this.xp > 0;
    }

    public CompoundTag saveToNbt() {
        ListTag armor = new ListTag();
        ListTag items = new ListTag();
        CompoundTag offhand = new CompoundTag();
        this.armor.forEach(stack -> armor.add((Object)stack.m_41739_(new CompoundTag())));
        if (!this.offhand.isEmpty()) {
            this.offhand.get(0).m_41739_(offhand);
        }
        this.items.forEach(stack -> items.add((Object)stack.m_41739_(new CompoundTag())));
        CompoundTag allItems = new CompoundTag();
        allItems.m_128365_("Armor", (Tag)armor);
        allItems.m_128365_("Items", (Tag)items);
        allItems.m_128365_("Offhand", (Tag)offhand);
        allItems.m_128405_("Xp", this.xp);
        return allItems;
    }

    public static ObeliskInventory readFromNbt(CompoundTag tag) {
        CompoundTag compound;
        ObeliskInventory inventory = new ObeliskInventory();
        if (tag.m_128425_("Armor", 9)) {
            for (Tag itemTag : tag.m_128437_("Armor", 10)) {
                if (!(itemTag instanceof CompoundTag)) continue;
                compound = (CompoundTag)itemTag;
                inventory.armor.add(ItemStack.m_41712_((CompoundTag)compound));
            }
        }
        if (tag.m_128425_("Items", 9)) {
            for (Tag itemTag : tag.m_128437_("Items", 10)) {
                if (!(itemTag instanceof CompoundTag)) continue;
                compound = (CompoundTag)itemTag;
                inventory.items.add(ItemStack.m_41712_((CompoundTag)compound));
            }
        }
        if (tag.m_128425_("Offhand", 10)) {
            inventory.offhand.add(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Offhand")));
        }
        if (tag.m_128425_("Xp", 3)) {
            inventory.xp = tag.m_128451_("Xp");
        }
        return inventory;
    }
}

